/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupChatManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class RenderEvents {
    private static final class_2960 MICROPHONE_ICON = new class_2960("voicechat", "textures/icons/microphone.png");
    private static final class_2960 WHISPER_MICROPHONE_ICON = new class_2960("voicechat", "textures/icons/microphone_whisper.png");
    private static final class_2960 MICROPHONE_OFF_ICON = new class_2960("voicechat", "textures/icons/microphone_off.png");
    private static final class_2960 SPEAKER_ICON = new class_2960("voicechat", "textures/icons/speaker.png");
    private static final class_2960 WHISPER_SPEAKER_ICON = new class_2960("voicechat", "textures/icons/speaker_whisper.png");
    private static final class_2960 SPEAKER_OFF_ICON = new class_2960("voicechat", "textures/icons/speaker_off.png");
    private static final class_2960 DISCONNECT_ICON = new class_2960("voicechat", "textures/icons/disconnected.png");
    private static final class_2960 GROUP_ICON = new class_2960("voicechat", "textures/icons/group.png");
    private final class_310 minecraft = class_310.method_1551();

    public RenderEvents() {
        ClientCompatibilityManager.INSTANCE.onRenderNamePlate(this::onRenderName);
        ClientCompatibilityManager.INSTANCE.onRenderHUD(this::onRenderHUD);
    }

    private void onRenderHUD(class_332 guiGraphics, float tickDelta) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
        ClientVoicechat client = ClientManager.getClient();
        if (manager.isDisconnected() && this.isStartup()) {
            return;
        }
        if (manager.isDisconnected()) {
            this.renderIcon(guiGraphics, DISCONNECT_ICON);
        } else if (manager.isDisabled()) {
            this.renderIcon(guiGraphics, SPEAKER_OFF_ICON);
        } else if (manager.isMuted() && VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE)) {
            this.renderIcon(guiGraphics, MICROPHONE_OFF_ICON);
        } else if (client != null && client.getMicThread() != null) {
            if (client.getMicThread().isWhispering()) {
                this.renderIcon(guiGraphics, WHISPER_MICROPHONE_ICON);
            } else if (client.getMicThread().isTalking()) {
                this.renderIcon(guiGraphics, MICROPHONE_ICON);
            }
        }
        if (manager.getGroupID() != null && VoicechatClient.CLIENT_CONFIG.showGroupHUD.get().booleanValue()) {
            GroupChatManager.renderIcons(guiGraphics);
        }
    }

    private boolean isStartup() {
        ClientVoicechat client = ClientManager.getClient();
        return client != null && System.currentTimeMillis() - client.getStartTime() < 5000L;
    }

    private void renderIcon(class_332 guiGraphics, class_2960 texture) {
        guiGraphics.method_51448().method_22903();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = VoicechatClient.CLIENT_CONFIG.hudIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.hudIconPosY.get();
        if (posX < 0) {
            guiGraphics.method_51448().method_22904((double)this.minecraft.method_22683().method_4486(), 0.0, 0.0);
        }
        if (posY < 0) {
            guiGraphics.method_51448().method_22904(0.0, (double)this.minecraft.method_22683().method_4502(), 0.0);
        }
        guiGraphics.method_51448().method_22904((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.hudIconScale.get().floatValue();
        guiGraphics.method_51448().method_22905(scale, scale, 1.0f);
        guiGraphics.method_25290(texture, posX < 0 ? -16 : 0, posY < 0 ? -16 : 0, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.method_51448().method_22909();
    }

    private void onRenderName(class_1297 entity, class_2561 component, class_4587 stack, class_4597 vertexConsumers, int light) {
        if (!this.shouldShowIcons()) {
            return;
        }
        if (VoicechatClient.CLIENT_CONFIG.hideIcons.get().booleanValue()) {
            return;
        }
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        if (entity == this.minecraft.field_1724) {
            return;
        }
        if (!this.minecraft.field_1690.field_1842) {
            ClientPlayerStateManager manager = ClientManager.getPlayerStateManager();
            ClientVoicechat client = ClientManager.getClient();
            UUID groupId = manager.getGroup(player);
            if (client != null && client.getTalkCache().isWhispering((class_1297)player)) {
                this.renderPlayerIcon(player, component, WHISPER_SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (client != null && client.getTalkCache().isTalking((class_1297)player)) {
                this.renderPlayerIcon(player, component, SPEAKER_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisconnected(player)) {
                this.renderPlayerIcon(player, component, DISCONNECT_ICON, stack, vertexConsumers, light);
            } else if (groupId != null && !groupId.equals(manager.getGroupID())) {
                this.renderPlayerIcon(player, component, GROUP_ICON, stack, vertexConsumers, light);
            } else if (manager.isPlayerDisabled(player)) {
                this.renderPlayerIcon(player, component, SPEAKER_OFF_ICON, stack, vertexConsumers, light);
            }
        }
    }

    private void renderPlayerIcon(class_1657 player, class_2561 component, class_2960 texture, class_4587 matrixStackIn, class_4597 buffer, int light) {
        matrixStackIn.method_22903();
        matrixStackIn.method_22904(0.0, (double)player.method_17682() + 0.5, 0.0);
        matrixStackIn.method_22907(this.minecraft.method_1561().method_24197());
        matrixStackIn.method_22905(-0.025f, -0.025f, 0.025f);
        matrixStackIn.method_22904(0.0, -1.0, 0.0);
        float offset = this.minecraft.field_1772.method_27525((class_5348)component) / 2 + 2;
        class_4588 builder = buffer.getBuffer(class_1921.method_23028((class_2960)texture));
        int alpha = 32;
        if (player.method_21751()) {
            RenderEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        } else {
            RenderEvents.vertex(builder, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, light);
            RenderEvents.vertex(builder, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, light);
            class_4588 builderSeeThrough = buffer.getBuffer(class_1921.method_23030((class_2960)texture));
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset, 10.0f, 0.0f, 0.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 10.0f, 0.0f, 1.0f, 1.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset + 10.0f, 0.0f, 0.0f, 1.0f, 0.0f, alpha, light);
            RenderEvents.vertex(builderSeeThrough, matrixStackIn, offset, 0.0f, 0.0f, 0.0f, 0.0f, alpha, light);
        }
        matrixStackIn.method_22909();
    }

    private boolean shouldShowIcons() {
        if (ClientManager.getClient() != null && ClientManager.getClient().getConnection() != null && ClientManager.getClient().getConnection().isInitialized()) {
            return true;
        }
        return this.minecraft.method_1558() != null && !this.minecraft.method_1558().method_2994();
    }

    private static void vertex(class_4588 builder, class_4587 matrixStack, float x, float y, float z, float u, float v, int light) {
        RenderEvents.vertex(builder, matrixStack, x, y, z, u, v, 255, light);
    }

    private static void vertex(class_4588 builder, class_4587 matrixStack, float x, float y, float z, float u, float v, int alpha, int light) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        builder.method_22918(entry.method_23761(), x, y, z).method_1336(255, 255, 255, alpha).method_22913(u, v).method_22922(class_4608.field_21444).method_22916(light).method_23763(entry.method_23762(), 0.0f, 0.0f, -1.0f).method_1344();
    }
}

