/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeList;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.plugins.CategoryManager;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ClientCategoryManager
extends CategoryManager {
    protected final Map<String, class_2960> images = new ConcurrentHashMap<String, class_2960>();

    public ClientCategoryManager() {
        CommonCompatibilityManager.INSTANCE.getNetManager().addCategoryChannel.setClientListener((client, handler, packet) -> {
            this.addCategory(packet.getCategory());
            Voicechat.logDebug("Added category {}", packet.getCategory().getId());
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().removeCategoryChannel.setClientListener((client, handler, packet) -> {
            this.removeCategory(packet.getCategoryId());
            Voicechat.logDebug("Removed category {}", packet.getCategoryId());
        });
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::clear);
    }

    @Override
    public void addCategory(VolumeCategoryImpl category) {
        super.addCategory(category);
        if (category.getIcon() != null) {
            this.registerImage(category.getId(), this.fromIntArray(category.getIcon()));
        }
        AdjustVolumeList.update();
    }

    @Override
    @Nullable
    public VolumeCategoryImpl removeCategory(String categoryId) {
        VolumeCategoryImpl volumeCategory = super.removeCategory(categoryId);
        this.unRegisterImage(categoryId);
        AdjustVolumeList.update();
        return volumeCategory;
    }

    public void clear() {
        this.categories.keySet().forEach(this::unRegisterImage);
        this.categories.clear();
    }

    private void registerImage(String id, class_1011 image) {
        class_2960 resourceLocation = class_310.method_1551().method_1561().field_4685.method_4617(id, new class_1043(image));
        this.images.put(id, resourceLocation);
    }

    private void unRegisterImage(String id) {
        class_2960 resourceLocation = this.images.get(id);
        if (resourceLocation != null) {
            class_310.method_1551().method_1561().field_4685.method_4615(resourceLocation);
            this.images.remove(id);
        }
    }

    private class_1011 fromIntArray(int[][] icon) {
        if (icon.length != 16) {
            throw new IllegalStateException("Icon is not 16x16");
        }
        class_1011 nativeImage = new class_1011(16, 16, true);
        for (int x = 0; x < icon.length; ++x) {
            if (icon[x].length != 16) {
                nativeImage.close();
                throw new IllegalStateException("Icon is not 16x16");
            }
            for (int y = 0; y < icon.length; ++y) {
                nativeImage.method_4305(x, y, icon[x][y]);
            }
        }
        return nativeImage;
    }

    public class_2960 getTexture(String id, class_2960 defaultImage) {
        return this.images.getOrDefault(id, defaultImage);
    }
}

