/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import com.google.common.primitives.Floats;

public class GeometrySort {
    private static final int MERGESORT_NO_REC = 16;

    public static void mergeSort(int[] indices, float[] distance) {
        GeometrySort.mergeSort(indices, 0, indices.length, distance);
    }

    public static void mergeSort(int[] indices, int from, int to, float[] distance) {
        GeometrySort.mergeSort(indices, from, to, distance, (int[])indices.clone());
    }

    public static void mergeSort(int[] indices, int from, int to, float[] distance, int[] supp) {
        int len = to - from;
        if (len < 16) {
            GeometrySort.insertionSort(indices, from, to, distance);
            return;
        }
        int mid = from + to >>> 1;
        GeometrySort.mergeSort(supp, from, mid, distance, indices);
        GeometrySort.mergeSort(supp, mid, to, distance, indices);
        if (Floats.compare((float)distance[supp[mid]], (float)distance[supp[mid - 1]]) <= 0) {
            System.arraycopy(supp, from, indices, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            indices[i] = q >= to || p < mid && Floats.compare((float)distance[supp[q]], (float)distance[supp[p]]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    private static void insertionSort(int[] a, int from, int to, float[] distance) {
        int i = from;
        while (++i < to) {
            int t = a[i];
            int j = i;
            int u = a[j - 1];
            while (Floats.compare((float)distance[u], (float)distance[t]) < 0) {
                a[j] = u;
                if (from == j - 1) {
                    --j;
                    break;
                }
                u = a[--j - 1];
            }
            a[j] = t;
        }
    }
}

