/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.arena;

import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferSegment;
import me.jellysquid.mods.sodium.client.gl.arena.PendingUpload;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBuffer;
import me.jellysquid.mods.sodium.client.gl.buffer.GlBufferUsage;
import me.jellysquid.mods.sodium.client.gl.buffer.GlMutableBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import org.lwjgl.system.MemoryUtil;

public class SwapBufferArena
implements GlBufferArena {
    private final Reference2ObjectMap<GlBufferSegment, StashedData> active = new Reference2ObjectOpenHashMap();
    private final GlMutableBuffer deviceBuffer;
    private final GlMutableBuffer stagingBuffer;
    private int used;

    public SwapBufferArena(CommandList commandList) {
        this.deviceBuffer = commandList.createMutableBuffer();
        this.stagingBuffer = commandList.createMutableBuffer();
    }

    @Override
    public int getDeviceUsedMemory() {
        return this.used;
    }

    @Override
    public int getDeviceAllocatedMemory() {
        return this.used;
    }

    @Override
    public void free(GlBufferSegment entry) {
        StashedData data = (StashedData)this.active.remove((Object)entry);
        if (data == null) {
            throw new IllegalStateException("Double-free");
        }
        this.used -= entry.getLength();
        data.destroy();
    }

    @Override
    public void delete(CommandList commands) {
        for (StashedData data : this.active.values()) {
            data.destroy();
        }
        this.active.clear();
        commands.deleteBuffer(this.deviceBuffer);
        commands.deleteBuffer(this.stagingBuffer);
    }

    @Override
    public boolean isEmpty() {
        return this.used == 0;
    }

    @Override
    public GlBuffer getBufferObject() {
        return this.deviceBuffer;
    }

    @Override
    public boolean upload(CommandList commandList, Stream<PendingUpload> stream) {
        List uploads = stream.collect(Collectors.toList());
        int totalBytes = uploads.stream().mapToInt(PendingUpload::getLength).sum() + this.active.values().stream().mapToInt(i -> i.size).sum();
        ByteBuffer buffer = MemoryUtil.memAlloc((int)totalBytes);
        int writePointer = 0;
        if (!this.active.isEmpty()) {
            for (Map.Entry entry : this.active.entrySet()) {
                GlBufferSegment seg = (GlBufferSegment)entry.getKey();
                StashedData data = (StashedData)entry.getValue();
                MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)data.buf), (long)MemoryUtil.memAddress((ByteBuffer)buffer, (int)writePointer), (long)data.size);
                seg.setOffset(writePointer);
                writePointer += seg.getLength();
            }
        }
        for (PendingUpload upload : uploads) {
            ByteBuffer payload = upload.getDataBuffer().getDirectBuffer();
            GlBufferSegment seg = new GlBufferSegment(this, writePointer, payload.remaining());
            upload.setResult(seg);
            this.used += seg.getLength();
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)payload), (long)MemoryUtil.memAddress((ByteBuffer)buffer, (int)seg.getOffset()), (long)seg.getLength());
            writePointer += seg.getLength();
            StashedData stashedData = new StashedData(payload);
            this.active.put((Object)seg, (Object)stashedData);
        }
        commandList.uploadData(this.stagingBuffer, buffer, GlBufferUsage.STREAM_COPY);
        commandList.allocateStorage(this.deviceBuffer, buffer.remaining(), GlBufferUsage.STATIC_DRAW);
        commandList.copyBufferSubData(this.stagingBuffer, this.deviceBuffer, 0L, 0L, buffer.remaining());
        commandList.allocateStorage(this.stagingBuffer, 0L, GlBufferUsage.STREAM_COPY);
        MemoryUtil.memFree((Buffer)buffer);
        return true;
    }

    private static class StashedData {
        public ByteBuffer buf;
        public int size;

        public StashedData(ByteBuffer src) {
            ByteBuffer copy = MemoryUtil.memAlloc((int)src.remaining());
            MemoryUtil.memCopy((ByteBuffer)src, (ByteBuffer)copy);
            this.size = copy.remaining();
            this.buf = copy;
        }

        public void destroy() {
            MemoryUtil.memFree((Buffer)this.buf);
        }
    }
}

