/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import mjson.Json;
import net.fabricmc.installer.util.Utils;

public class ProfileInstaller {
    private final Path mcDir;

    public ProfileInstaller(Path mcDir) {
        this.mcDir = mcDir;
    }

    public List<LauncherType> getInstalledLauncherTypes() {
        return Arrays.stream(LauncherType.values()).filter(launcherType -> Files.exists(this.mcDir.resolve(launcherType.profileJsonName), new LinkOption[0])).collect(Collectors.toList());
    }

    public void setupProfile(String name, String gameVersion, LauncherType launcherType) throws IOException {
        String profileName;
        Json profile;
        Path launcherProfiles = this.mcDir.resolve(launcherType.profileJsonName);
        if (!Files.exists(launcherProfiles, new LinkOption[0])) {
            throw new FileNotFoundException("Could not find " + launcherType.profileJsonName);
        }
        System.out.println("Creating profile");
        Json jsonObject = Json.read(Utils.readString(launcherProfiles));
        Json profiles = jsonObject.at("profiles");
        if (profiles == null) {
            profiles = Json.object();
            jsonObject.set("profiles", profiles);
        }
        if ((profile = profiles.at(profileName = "fabric-loader-" + gameVersion)) == null) {
            profile = ProfileInstaller.createProfile(profileName);
            profiles.set(profileName, profile);
        }
        profile.set("lastVersionId", (Object)name);
        Utils.writeToFile(launcherProfiles, jsonObject.toString());
    }

    private static Json createProfile(String name) {
        Json jsonObject = Json.object();
        jsonObject.set("name", (Object)name);
        jsonObject.set("type", (Object)"custom");
        jsonObject.set("created", (Object)Utils.ISO_8601.format(new Date()));
        jsonObject.set("lastUsed", (Object)Utils.ISO_8601.format(new Date()));
        jsonObject.set("icon", (Object)Utils.getProfileIcon());
        return jsonObject;
    }

    public static enum LauncherType {
        WIN32("launcher_profiles.json"),
        MICROSOFT_STORE("launcher_profiles_microsoft_store.json");

        public final String profileJsonName;

        private LauncherType(String profileJsonName) {
            this.profileJsonName = profileJsonName;
        }
    }
}

